/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#include <drmcommon.h>
#include <drmcrt.h>
#include <drmutilities.h>
#include <oemimpl.h>

#if DRM_USE_MAIN_WRAPPER

#ifndef _UNICODE
#error _UNICODE not defined with DRM_USE_MAIN_WRAPPER in cmdlnpars.c
#endif

DRM_INT DRM_API main( DRM_INT argc, DRM_CHAR **argv )
{
#if EMBEDDED_WITH_NO_PARAMS
    wmain( 0, NULL );
#else
    DRM_WCHAR **ppwargv = NULL;
    DRM_INT     i       = 0;
    DRM_BOOL    fOK     = TRUE;

    ppwargv = (DRM_WCHAR**)OEM_malloc( argc * SIZEOF( DRM_WCHAR* ) );

    if (ppwargv != NULL)
    {
        for (i = 0; i < argc; i++)
        {
            DRM_SUBSTRING dasstr = { 0 };
            DRM_STRING    dstr   = EMPTY_DRM_STRING;
            
            ppwargv [i] = (DRM_WCHAR *) OEM_malloc (strlen(argv [i]) * SIZEOF(DRM_WCHAR));
            
            if (ppwargv [i] != NULL)
            {
                dstr.pwszString =        ppwargv [i];
                dstr.cchString  = DRM_wcslen(ppwargv [i]);
                
                DRM_UTL_PromoteANSItoUNICODE(argv [i], &dasstr, &dstr);
            }
            else
            {
                fOK = FALSE;
            }
        }

        if (fOK)
        {
            wmain(argc, ppwargv);
        }
        
        for (i = 0; i < argc; i++)
        {
            if (ppwargv [i] != NULL)
            {
                OEM_free(ppwargv [i]);
            }
        }
        
        OEM_free(ppwargv);        
    }
#endif
    
    return 0;
}

#endif

DRM_BOOL DRM_API DRM_CMD_ParseCmdLine(
    IN  const DRM_WCHAR  *pwszArgument,
    OUT DRM_WCHAR        *pwchOptionChar,
    OUT DRM_CONST_STRING *pwszParam,
    OUT DRM_CONST_STRING *pwszExtra)
{
    DRM_BOOL fRet = FALSE;
    DRM_DWORD i, 
              dwLen;

    if ( pwszArgument   == NULL || 
         pwchOptionChar == NULL )
    {
        goto ErrorExit;
    }

    dwLen = DRM_wcslen( pwszArgument );
    if ( !( pwszArgument[0] == g_wchMinus || pwszArgument[0] == g_wchForwardSlash ) || dwLen < 2 )
    {
        goto ErrorExit;
    }

    *pwchOptionChar = pwszArgument[1];
    if ( pwszParam == NULL )
    {
        fRet = TRUE;
        goto ErrorExit;
    }

    /* parse parameter */    
    pwszParam->cchString = 0;
    pwszParam->pwszString = NULL;
    if ( pwszExtra )
    {
        pwszExtra->cchString = 0;
        pwszExtra->pwszString = NULL;
    }

    if ( dwLen<4 || pwszArgument[2]!=g_wchColon )
    {
        fRet = TRUE;
        goto ErrorExit;
    }
    
    /* parse parameter */
    pwszParam->pwszString = &pwszArgument[3];
    for (i=3; pwszArgument[i]!= g_wchNull && pwszArgument[i]!=g_wchComma; i++)
    {
        ++pwszParam->cchString;
    }

    if ( i==dwLen || !pwszExtra )
    {
        fRet = TRUE;
        goto ErrorExit;
    }

    if ( pwszArgument[i+1] == g_wchNull )
    {
        goto ErrorExit;
    }

    /* parse the extra pameter */
    ++i;
    pwszExtra->pwszString = &pwszArgument[i];
    for (; pwszArgument[i]!=g_wchNull; i++)
    {
        ++pwszExtra->cchString;
    }

    fRet = TRUE;
    
ErrorExit:
    return fRet;
}

